/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model;

import com.faboslav.friendsandfoes.common.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.common.entity.MaulerEntity;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.util.animation.AnimationMath;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public final class MaulerEntityModel<T extends MaulerEntity>
extends AnimatedEntityModel<T> {
    private static final String MODEL_PART_ROOT = "root";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_UPPER_JAW = "upperJaw";
    private static final String MODEL_PART_LOWER_JAW = "lowerJaw";
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_FRONT_LEFT_LEG = "frontLeftLeg";
    private static final String MODEL_PART_FRONT_RIGHT_LEG = "frontRightLeg";
    private static final String MODEL_PART_BACK_LEFT_LEG = "backLeftLeg";
    private static final String MODEL_PART_BACK_RIGHT_LEG = "backRightLeg";
    private final class_630 head;
    private final class_630 upperJaw;
    private final class_630 lowerJaw;
    private final class_630 body;
    private final class_630 frontLeftLeg;
    private final class_630 frontRightLeg;
    private final class_630 backLeftLeg;
    private final class_630 backRightLeg;

    public MaulerEntityModel(class_630 root) {
        super(root);
        this.head = this.root.method_32086(MODEL_PART_HEAD);
        this.upperJaw = this.head.method_32086(MODEL_PART_UPPER_JAW);
        this.lowerJaw = this.head.method_32086(MODEL_PART_LOWER_JAW);
        this.body = this.root.method_32086(MODEL_PART_BODY);
        this.frontLeftLeg = this.root.method_32086(MODEL_PART_FRONT_LEFT_LEG);
        this.frontRightLeg = this.root.method_32086(MODEL_PART_FRONT_RIGHT_LEG);
        this.backLeftLeg = this.root.method_32086(MODEL_PART_BACK_LEFT_LEG);
        this.backRightLeg = this.root.method_32086(MODEL_PART_BACK_RIGHT_LEG);
        this.setCurrentModelTransforms(MODEL_PART_ROOT, this.root);
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        root.method_32117(MODEL_PART_HEAD, class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)20.0f, (float)4.0f));
        class_5610 head = root.method_32116(MODEL_PART_HEAD);
        head.method_32117(MODEL_PART_UPPER_JAW, class_5606.method_32108().method_32101(0, 0).method_32097(-4.5f, -3.0f, -10.0f, 9.0f, 3.0f, 10.0f), class_5603.method_32090((float)0.0f, (float)-2.0f, (float)1.0f));
        head.method_32117(MODEL_PART_LOWER_JAW, class_5606.method_32108().method_32101(0, 13).method_32097(-4.5f, 0.0f, -10.0f, 9.0f, 3.0f, 10.0f), class_5603.method_32090((float)0.0f, (float)-2.0f, (float)1.0f));
        root.method_32117(MODEL_PART_BODY, class_5606.method_32108().method_32101(0, 26).method_32098(-3.5f, 0.0f, -3.0f, 7.0f, 2.0f, 6.0f, new class_5605(0.01f)), class_5603.method_32090((float)0.0f, (float)20.0f, (float)1.0f));
        root.method_32117(MODEL_PART_FRONT_LEFT_LEG, class_5606.method_32108().method_32101(0, 5).method_32097(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), class_5603.method_32090((float)2.5f, (float)21.0f, (float)-1.0f));
        root.method_32117(MODEL_PART_FRONT_RIGHT_LEG, class_5606.method_32108().method_32101(0, 0).method_32097(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), class_5603.method_32090((float)-2.5f, (float)21.0f, (float)-1.0f));
        root.method_32117(MODEL_PART_BACK_LEFT_LEG, class_5606.method_32108().method_32101(0, 18).method_32097(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), class_5603.method_32090((float)2.5f, (float)21.0f, (float)3.0f));
        root.method_32117(MODEL_PART_BACK_RIGHT_LEG, class_5606.method_32108().method_32101(0, 13).method_32097(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), class_5603.method_32090((float)-2.5f, (float)21.0f, (float)3.0f));
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)64);
    }

    public void setAngles(T mauler, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.applyModelTransforms(MODEL_PART_ROOT, this.root);
        float burrowingDownAnimationProgress = ((MaulerEntity)mauler).getBurrowingDownAnimationProgress();
        float maulerHeightWithOffset = 10.0f;
        if (burrowingDownAnimationProgress > 0.0f && burrowingDownAnimationProgress < 1.0f) {
            float targetY = maulerHeightWithOffset * burrowingDownAnimationProgress;
            this.animateModelPartYPositionBasedOnProgress((AnimatedEntity)mauler, this.root, targetY, AnimationMath.absSin(animationProgress));
            return;
        }
        if (((MaulerEntity)mauler).getBurrowingDownAnimationProgress() == 1.0f) {
            this.root.field_3656 = maulerHeightWithOffset;
            return;
        }
        this.head.field_3654 = headPitch * 0.005f;
        float baseSpeed = mauler.method_29511() ? 14.0f : 10.0f;
        float jumpHeight = mauler.method_29511() ? -4.5f : -2.5f;
        this.root.field_3656 = jumpHeight * Math.abs(class_3532.method_24504((float)limbAngle, (float)baseSpeed) * limbDistance);
        float legPitch = class_3532.method_24504((float)limbAngle, (float)baseSpeed) * limbDistance;
        float frontLegPitch = -1.5f * legPitch;
        float backLegPitch = 1.5f * legPitch;
        this.frontLeftLeg.field_3654 = frontLegPitch;
        this.frontRightLeg.field_3654 = frontLegPitch;
        this.backLeftLeg.field_3654 = backLegPitch;
        this.backRightLeg.field_3654 = backLegPitch;
        if (mauler.method_29511() && !((MaulerEntity)mauler).isBurrowedDown() && ((MaulerEntity)mauler).isMoving() && mauler.method_24828() && mauler.method_18798().method_10214() <= 1.0E-5) {
            float targetX = AnimationMath.toRadians(5.0) + AnimationMath.toRadians(-65.0) * AnimationMath.absSin(animationProgress, 1.0f, 0.35f);
            float delta = AnimationMath.absSin(animationProgress);
            MaulerEntityModel.animateModelPartXRotationBasedOnProgress(mauler, this.upperJaw, targetX, delta);
            MaulerEntityModel.animateModelPartXRotationBasedOnTicks(mauler, this.lowerJaw, AnimationMath.toRadians(-5.0), 10);
        } else {
            MaulerEntityModel.animateModelPartXRotationBasedOnTicks(mauler, this.upperJaw, 0.0f, 10);
            MaulerEntityModel.animateModelPartXRotationBasedOnTicks(mauler, this.lowerJaw, 0.0f, 10);
        }
    }
}

